#include <allegro.h>

#include "actor.h"
#include "main.h"
#include "alienship.h"
#include "mothership.h"
#include "shot.h"
#include "man.h"
#include "F18.h"
#include "tree.h"
#include "game.h"
#include "sectors.h"
#include "number.h"
#include "station.h"
#include "tower.h"
#include "fir.h"

void actor_init(ACTOR *actor)
{
	actor->x = 0;
	actor->y = 0;
	actor->dx = 0;
	actor->dy = 0;
	actor->frame = 0;
	actor->hit = 0;
	actor->anim = 0;
	actor->timer = 0;
	actor->type = 0;
	actor->health = 1000;
}

void actor_draw(ACTOR *actor, int x, int y)
{
	int xp = actor->x - x;
	int yp = actor->y - y;
	if (xp > SECTOR_DIMENSION * SECTORS / 2) {
		xp -= SECTOR_DIMENSION * SECTORS;
	}
	if (xp < -SECTOR_DIMENSION * SECTORS / 2) {
		xp += SECTOR_DIMENSION * SECTORS;
	}
	actor->draw(
		actor,
		SCREEN_W / 2 + xp,
		SCREEN_H / 2 - yp);
/*
	rect(page,
		SCREEN_W / 2 + actor->x - x + actor->l,
		SCREEN_H / 2 - actor->y + y - actor->t,
		SCREEN_W / 2 + actor->x - x + actor->r,
		SCREEN_H / 2 - actor->y + y - actor->b,
		7);
	*/
}

int actor_collide(ACTOR *actor, ACTOR *with)
{
	return (actor->x + actor->r >= with->x + with->l &&
		actor->y + actor->t >= with->y + with->b &&
		actor->x + actor->l <= with->x + with->r &&
		actor->y + actor->b <= with->y + with->t);
}

int actor_inside(ACTOR *actor, ACTOR *with)
{
	return (actor->x >= with->x + with->l &&
		actor->y >= with->y + with->b &&
		actor->x <= with->x + with->r &&
		actor->y <= with->y + with->t);
}

void actors_process(void)
{
	int i;
	
	alienship_process();
	mothership_process();
	station_process();
	for (i = 0; i < 4; i++) number_process(&number_population[i], &population);
	for (i = 0; i < 3; i++) number_process(&number_shield[i], &shield);
	for (i = 0; i < 4; i++) number_process(&number_ammo[i], &ammo);
	for (i = 0; i < shots_num; i++) shot_process(i);
	for (i = 0; i < mans_num; i++) {
		switch (man[i]->type) {
			case MAN: man_process(i); break;
			case TREE: tree_process(i); break;
			case F18: F18_process(i); break;
			case TOWER: tower_process(i); break;
			case FIR: fir_process(i); break;
		}
	}
}

void actors_draw(int x, int y)
{
	int i;
	actor_draw(&mothership, x, y);
	actor_draw(&alienship, x, y);
	actor_draw(&station, x, y);
	for (i = 0; i < shots_num; i++) actor_draw(&shot[i], x, y);
	for (i = 0; i < mans_num; i++) actor_draw(man[i], x, y);
	for (i = 0; i < 4; i++) number_population[i].draw(&number_population[i], 20 + i * 40, 25);
	for (i = 0; i < 3; i++) number_shield[i].draw(&number_shield[i], SCREEN_W / 2 - 60 + i * 40, 25);
	for (i = 0; i < 4; i++) number_ammo[i].draw(&number_ammo[i],  SCREEN_W - 150 + i * 40, 25);
}
